<?php
// Evitar cache
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Cache-Control: no-cache");
header("Pragma: no-cache");

session_start();

if (isset($_SESSION['loggedin']) == TRUE) {
    header("location: main.php");
    exit;
}

$db = new SQLite3('./api/.db.db');
$db->exec("CREATE TABLE IF NOT EXISTS users(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, master TEXT, cod TEXT, username TEXT, password TEXT)");

$rows = $db->query("SELECT COUNT(*) as count FROM users");
$row = $rows->fetchArray();
$numRows = $row['count'];

if ($numRows == 0) {
    $db->exec("INSERT INTO users(id, master, cod, username, password) VALUES(1, 'T', '', 'admin', 'admin')");
}

if (isset($_POST["login"])) {
    $username = $_POST["username"];
    $password_input = $_POST["password"];

    $sql = "SELECT * FROM users WHERE username = :username";
    $stmt = $db->prepare($sql);
    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
    $ret = $stmt->execute();

    $user = $ret->fetchArray(SQLITE3_ASSOC);

    if ($user && $user['password'] === $password_input) {
        session_regenerate_id();
        $_SESSION['loggedin'] = TRUE;
        $_SESSION['id'] = $user['id'];
        $_SESSION['cod'] = $user['cod'];
        $_SESSION['master'] = $user['master'];
        $_SESSION['name'] = $user['username'];

        header('Location: user_update.php');
        exit;
    } else {
        header('Location: ./api/erro.php');
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Painel Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap e Google Fonts -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@600&display=swap" rel="stylesheet">

    <style>
        html, body {
            margin: 0;
            padding: 0;
            height: 100%;
            font-family: 'Montserrat', sans-serif;
            overflow: hidden;
            background-color: #000000; /* fundo preto */
        }

        #particles-js {
            position: absolute;
            width: 100%;
            height: 100%;
            background-color: #000000; /* fundo preto */
            background-size: cover;
            background-position: center;
            z-index: 0;
        }

        .center-wrapper {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1;
            width: 100%;
            padding: 20px;
        }

        .login-container {
            background: rgba(0, 31, 38, 0.85); /* azul escuro transparente */
            padding: 40px 30px;
            border-radius: 15px;
            box-shadow: 0 0 30px rgba(0, 255, 255, 0.3); /* glow ciano */
            max-width: 500px;
            width: 100%;
            margin: auto;
            border: 2px solid #00ffff; /* borda ciano sólida */
        }

        .login-container h2 {
            color: #00ffff; /* texto ciano */
            font-size: 28px;
            text-align: center;
            margin-bottom: 30px;
            text-shadow: 0 0 10px #00ffff;
        }

        .form-control {
            background-color: #111;
            border: 1px solid #00ffff;
            color: #00ffff;
        }

        .form-control:focus {
            background-color: #000;
            border-color: #00e6e6;
            color: #00ffff;
            box-shadow: 0 0 5px #00ffff;
        }

        .btn-success {
            background-color: #00ffff;
            border: none;
            font-weight: bold;
            color: #000;
            transition: background-color 0.3s ease;
        }

        .btn-success:hover {
            background-color: #00e6e6;
            color: #000;
        }

        ::placeholder {
            color: #66ffff;
            opacity: 0.7;
        }

        @media (max-width: 576px) {
            .login-container {
                padding: 30px 20px;
            }

            .login-container h2 {
                font-size: 22px;
            }

            .form-control {
                font-size: 14px;
            }

            .btn {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>

<!-- FUNDO COM PARTÍCULAS -->
<div id="particles-js"></div>

<div class="center-wrapper">
    <div class="login-container">
        <h2>Painel Admin</h2>
        <form method="post">
            <input type="text" class="form-control mb-3" placeholder="Usuário" name="username" required autofocus>
            <input type="password" class="form-control mb-4" placeholder="Senha" name="password" required>
            <button class="btn btn-success btn-block" name="login" type="submit">ACESSAR</button>
        </form>
        <?php include('includes/footer1.php'); ?>
    </div>
</div>

<!-- PARTICLES JS -->
<script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
<script>
particlesJS("particles-js", {
    "particles": {
        "number": {
            "value": 80
        },
        "color": {
            "value": "#00ffff" /* ciano */
        },
        "shape": {
            "type": "circle"
        },
        "opacity": {
            "value": 0.6
        },
        "size": {
            "value": 3
        },
        "line_linked": {
            "enable": true,
            "distance": 150,
            "color": "#00ffff",
            "opacity": 0.4,
            "width": 1
        },
        "move": {
            "enable": true,
            "speed": 3
        }
    },
    "interactivity": {
        "detect_on": "canvas",
        "events": {
            "onhover": {
                "enable": true,
                "mode": "grab"
            },
            "onclick": {
                "enable": true,
                "mode": "push"
            }
        },
        "modes": {
            "grab": {
                "distance": 140,
                "line_linked": {
                    "opacity": 1
                }
            }
        }
    },
    "retina_detect": true
});
</script>

</body>
</html>
